import 'dart:async';
import 'package:admin_desktop/domain/di/dependency_manager.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service/riverpod/service/service_state.dart';

import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:flutter/material.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';

class ServiceNotifier extends StateNotifier<ServiceState> {
  int _page = 0;

  ServiceNotifier() : super(const ServiceState());

  Future<void> fetchServices({
    required BuildContext context,
    bool isRefresh = false,
    RefreshController? controller,
    int? masterId,
  }) async {
    if (isRefresh) {
      controller?.resetNoData();
      _page = 0;
      state = state.copyWith(services: [], isLoading: true);
    }
    final res = await serviceRepository.getServices(
      page: ++_page,
    );

    // if (!state.hasMore && !isRefresh) {
    //   state = state.copyWith(isLoading: false);
    //   return;
    // }

    res.when(success: (data) {
      List<ServiceData> list = List.from(state.services);
      list.addAll(data.data ?? []);
      state = state.copyWith(
          isLoading: false,
          services: list,
          totalCount: data.meta?.total ?? 0,
          hasMore: list.length < (data.meta?.total ?? 0));
      if (isRefresh) {
        controller?.refreshCompleted();
      } else if (data.data?.isEmpty ?? true) {
        controller?.loadNoData();
        return;
      }
      controller?.loadComplete();
      return;
    }, failure: (failure, status) {
      state = state.copyWith(isLoading: false);
      AppHelpers.errorSnackBar(context, text: failure);
    });
  }

  Future<void> fetchAllServices({
    required BuildContext context,
    bool? isRefresh,
    RefreshController? controller,
  }) async {
    if (isRefresh ?? false) {
      controller?.resetNoData();
      _page = 0;
      state = state.copyWith(allServices: [], isLoading: true, hasMore: true);
    }
    final res = await serviceRepository.getServices(page: ++_page);
    res.when(success: (data) {
      List<ServiceData> list = List.from(state.allServices);
      list.addAll(data.data ?? []);
      state = state.copyWith(
          isLoading: false,
          allServices: list,
          hasMore: list.length < (data.meta?.total ?? 0));
      if (isRefresh ?? false) {
        controller?.refreshCompleted();
        return;
      } else if (data.data?.isEmpty ?? true) {
        controller?.loadNoData();
        return;
      }
      controller?.loadComplete();
      return;
    }, failure: (failure, status) {
      state = state.copyWith(isLoading: false);
      AppHelpers.errorSnackBar(context, text: failure);
    });
  }

  Future<void> deleteService(BuildContext context, int? id) async {
    state = state.copyWith(isLoading: true);
    final response = await serviceRepository.deleteService(id);
    response.when(
      success: (success) {
        List<ServiceData> list = List.from(state.services);
        list.removeWhere((element) => element.id == id);
        state = state.copyWith(services: list, isLoading: false);
      },
      failure: (failure, status) {
        state = state.copyWith(isLoading: false);
        AppHelpers.showSnackBar(context, failure);
      },
    );
  }

  void addSelectOrder({int? id, required int orderLength}) {
    List list = List.from(state.selectProducts);
    if (state.selectProducts.contains(id)) {
      list.remove(id);
    } else {
      list.add(id ?? 0);
    }
    state = state.copyWith(selectProducts: list);

    if (list.length == orderLength) {
      state = state.copyWith(isAllSelect: true);
    } else {
      state = state.copyWith(isAllSelect: false);
    }
  }

  void allSelectOrder(List<ServiceData> orderList) {
    List list = [];
    if (!state.isAllSelect) {
      for (int i = 0; i < orderList.length; i++) {
        list.add(orderList[i].id);
      }
      state = state.copyWith(isAllSelect: true);
    } else {
      state = state.copyWith(isAllSelect: false);
    }
    state = state.copyWith(selectProducts: list);
  }
}
